<?php
App::uses('AppController', 'Controller');
/**
 * Afiliations Controller
 *
 * @property Afiliation $Afiliation
 * @property PaginatorComponent $Paginator
 * @property FileUploadComponent $FileUpload
 */
class AfiliationsController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator', 'FileUpload');

/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Afiliation->recursive = 0;
		$this->set('banners', $this->Paginator->paginate());
	}

/**
 * admin_add method
 *
 * @return void
 */
	public function admin_add(){
		
		if(!empty($this->request->data)){
			
			if($this->request->data['Afiliation']['bannerimage']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."banner";
				$target_path_for_database ="files"."/"."banner/";
				
				$filename = $this->request->data['Afiliation']['bannerimage']['name'];
				$tmpname  = $this->request->data['Afiliation']['bannerimage']['tmp_name'];
				$filesize = $this->request->data['Afiliation']['bannerimage']['size'];
				$filetype = $this->request->data['Afiliation']['bannerimage']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp');
				
				if(strlen($filename) > 0){
					$this->request->data['Afiliation']['imagename'] = $target_path_for_database.$filename;
				}else{
					$this->Session->setFlash("The file type is not valid.",true);
					$this->redirect(array('controller' => 'afiliations','action'=>'add'));
				}				
			}
						
			$this->request->data['Afiliation']['isctive'] = 1;
			if($this->Afiliation->save($this->request->data['Afiliation'])){
				$this->redirect(array('controller' => 'afiliations','action'=>'index'));	
			}
		}
	}

/**
 * admin_edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_edit($id = null) {
		
		if (!$this->Afiliation->exists($id)) {
			throw new NotFoundException(__('Invalid File Id.'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			
			if($this->request->data['Afiliation']['bannerimage']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."banner";
				$target_path_for_database ="files"."/"."banner/";
				
				$filename = $this->request->data['Afiliation']['bannerimage']['name'];
				$tmpname  = $this->request->data['Afiliation']['bannerimage']['tmp_name'];
				$filesize = $this->request->data['Afiliation']['bannerimage']['size'];
				$filetype = $this->request->data['Afiliation']['bannerimage']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp');
				
				if(strlen($filename) > 0){
					$this->request->data['Afiliation']['imagename'] = $target_path_for_database.$filename;
				}				
			}
			 
			if($this->Afiliation->save($this->request->data['Afiliation'])){
				$this->redirect(array('controller' => 'afiliations','action'=>'index'));	
			}else{
				$this->Session->setFlash(__('The file could not be edited. Please, try again.'));
				$this->redirect(array('action' => 'edit',$this->request->data['Afiliation']['id']));
			}
			
		}else {
			$options = array('conditions' => array('Afiliation.' . $this->Afiliation->primaryKey => $id));
			$this->request->data = $this->Afiliation->find('first', $options);
		}
	}

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
		$this->Afiliation->id = $id;
		if (!$this->Afiliation->exists()) {
			throw new NotFoundException(__('Invalid File'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Afiliation->delete()) {
			$this->Session->setFlash(__('The file has been deleted.'), 'default', array('class' => 'alert alert-success'));
		} else {
			$this->Session->setFlash(__('The file could not be deleted. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
		}
		return $this->redirect(array('action' => 'index'));
	}}
