<?php
App::uses('Controller', 'Controller');

class AppController extends Controller {
	
	var $uses = array('Generalsetting');
	
	public $components = array(
 		'Acl',
		'Auth' => array(
			'authorize' => array(
				'Actions' => array('actionPath' => 'controllers')
			)
		),
        'Session',
		'Cookie',
		'RequestHandler'
    );
    
    
	public $helpers = array(
        'Html',
        'Form',
        'Session',		
		'Text',
		'Js',
		'Fck'
    );
	
	function beforeFilter(){	
	
		$this->Auth->allow('index','view');
		
		//Configure AuthComponent
        $this->Auth->loginAction = array('controller' => 'users', 'action' => 'login');
        $this->Auth->logoutRedirect = array('controller' => 'users', 'action' => 'login');

		if (isset($this->params['prefix']) && $this->params['prefix'] == 'admin') {
            $this->layout = 'default';
        } 
		$this->set('auth', $this->Auth->user());    
		$this->set('acl', $this->Acl);
		$this->set('setting',$this->generalInformation());
		
		$this->Cookie->name = 'JBProduct';

	}

	public function removespace($str = null){
		$strinput = trim(preg_replace('/\s+/',' ', $str));
		return $strinput;	
	}
	
	protected function generalInformation(){
		$data = $this->Generalsetting->find('first');		
		return $data;
	}
			
}
