<?php
class CareersController extends AppController {
	var $name = 'Careers';
	public $components = array('Paginator','FileUpload');
	
	function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('view');
	}

	function index() {
		$this->layout = 'inner';
		$this->Career->recursive = 0;									
		$this->paginate = array('conditions' => array('Career.isactive' => 1),'limit'=>20);	
		$this->set('careers', $this->Paginator->paginate($this->Career));
	}

	function view($id = null) {
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid Career Id.', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('career', $this->Career->read(null, $id));
	}
	
	function admin_index() {
		$this->layout = 'default';
		$this->Career->recursive = 0;
		$this->paginate = array('order'=>'Career.created DESC');
		$this->set('careers', $this->Paginator->paginate());
	}
   
	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['Career']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."career";
					$target_path_for_database ="files"."/"."career/";
					$filename = $this->request->data['Career']['attachfile']['name'];
					$tmpname  = $this->request->data['Career']['attachfile']['tmp_name'];
					$filesize = $this->request->data['Career']['attachfile']['size'];
					$filetype = $this->request->data['Career']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,doc,docx,pdf,txt');				
					if(strlen($filename1) > 0){
						$this->request->data['Career']['attach_file'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			
			/*Date condersion here*/
			$this->request->data['Career']['deadline'] = strtotime(str_replace('/', '-', $this->request->data['Career']['deadline']));
				
			$this->Career->create();
			if ($this->Career->save($this->request->data)) {
				$this->Session->setFlash(__('The career infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The career infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid infromation!', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Career']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."career";
				$target_path_for_database ="files"."/"."career/";
				$filename = $this->request->data['Career']['attachfile']['name'];
				$tmpname  = $this->request->data['Career']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Career']['attachfile']['size'];
				$filetype = $this->request->data['Career']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif,doc,docx,pdf,txt');					
				if(strlen($filename1) > 0){
					
					if(!empty($this->request->data['Career']['attach_file'])){
						if(unlink($this->request->data['Career']['attach_file'])){
							$this->request->data['Career']['attach_file'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['Career']['attach_file'] = $target_path_for_database.$filename1;						
					}
					
				}
				
			}
			/*Date condersion here*/
			$this->request->data['Career']['deadline'] = strtotime(str_replace('/', '-', $this->request->data['Career']['deadline']));
			if ($this->Career->save($this->request->data)) {
				$this->Session->setFlash(__('The career infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The career infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Career']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Career->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Career infromation!', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Career->find('first',array('conditions'=>array('Career.id'=>$id),'fields'=>array('Career.attach_file')));
		if(!empty($filename['Career']['attach_file'])){
			if(unlink($filename['Career']['attach_file'])){
				if ($this->Career->delete($id)) {
					$this->Session->setFlash(__('Career infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Career->delete($id)) {
					$this->Session->setFlash(__('Career infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
			
			
		}else{
			if ($this->Career->delete($id)) {
				$this->Session->setFlash(__('Career infromation deleted.', true));
				$this->redirect(array('action'=>'index'));
			}	
		}
		
		$this->Session->setFlash(__('Career infromation was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>