<?php
class FileUploadComponent extends Component
{
    
    var $controller;
    
    /**
     * component statup
     */
    function startup(Controller $controller) {

        $this->controller=$controller;

    }//startup()
    
	function upload($filename, $tmpname, $filesize, $folder="", $types="") {
	    $file_title = $filename;
	    //Get file extension
	    $ext_arr = split("\.",basename($file_title));
	    $ext = strtolower($ext_arr[count($ext_arr)-1]); //Get the last extension
	
	    //Not really uniqe - but for all practical reasons, it is
		//Get Unique Name
	    $file_name = time()."_".rand(1000,9999).".".$ext;
	
	    $all_types = explode(",",strtolower($types));
	    if($types) {
	        if(in_array($ext,$all_types));
	        else {
				return null;
	        }
	    }
	
	    //Where the file must be uploaded to
	    if($folder) $folder .= '/';//Add a '/' at the end of the folder
	    $uploadfile = $folder . $file_name;
	
	    $result = null;
	    //Move the file from the stored location to the new location
	    if (!move_uploaded_file($tmpname, $uploadfile)) {
	        $result = "Cannot upload the file '".$filename."'"; //Show error if any.
	        if(!file_exists($folder)) {
	            $result .= " : Folder don't exist.";
	        } elseif(!is_writable($folder)) {
	            $result .= " : Folder not writable.";
	        } elseif(!is_writable($uploadfile)) {
	            $result .= " : File not writable.";
	        }
	        $file_name = null;
	        
	    } else {
	        if(!$filesize) { //Check if the file is made
	            @unlink($uploadfile);//Delete the Empty file
	            $file_name = null;
	            $result = "Empty file found - please use a valid file."; //Show the error message
	        } else {
	            chmod($uploadfile,0777);//Make it universally writable.
	        }
	    }
	
	    return $file_name;
	}
	
	function csvupload($filename, $tmpname, $filesize, $folder="", $types="") {
		
	    $file_title = $filename;
	    //Get file extension
	    $ext_arr = split("\.",basename($file_title));
	    $ext = strtolower($ext_arr[count($ext_arr)-1]); //Get the last extension
	
	    //Not really uniqe - but for all practical reasons, it is
		//Get Unique Name
	    $file_name = time()."_".rand(1000,9999).".".$ext;
	
	    $all_types = explode(",",strtolower($types));
	    if($types) {
	        if(in_array($ext,$all_types));
	        else {
				return null;
	        }
	    }
	
	    //Where the file must be uploaded to
	    if($folder) $folder .= '/';//Add a '/' at the end of the folder
	    $uploadfile = $folder . $file_name;
	
	    $result = null;
	    //Move the file from the stored location to the new location
	    if (!move_uploaded_file($tmpname, $uploadfile)) {
	        $result = "Cannot upload the file '".$filename."'"; //Show error if any.
	        if(!file_exists($folder)) {
	            $result .= " : Folder don't exist.";
	        } elseif(!is_writable($folder)) {
	            $result .= " : Folder not writable.";
	        } elseif(!is_writable($uploadfile)) {
	            $result .= " : File not writable.";
	        }
	        $file_name = null;
	        
	    } else {
	        if(!$filesize) { //Check if the file is made
	            @unlink($uploadfile);//Delete the Empty file
	            $file_name = null;
	            $result = "Empty file found - please use a valid file."; //Show the error message
	        } else {
	            chmod($uploadfile,0777);//Make it universally writable.
	        }
	    }
	
	    return $file_name;
	}
	
	function flashfileupload($filename, $tmpname, $filesize, $folder="", $types="") {
	    $file_title = $filename;
	    //Get file extension
	    $ext_arr = split("\.",basename($file_title));
	    $ext = strtolower($ext_arr[count($ext_arr)-1]); //Get the last extension
		echo $types;
	
	    //Not really uniqe - but for all practical reasons, it is
		//Get Unique Name		
	    $file_name = time()."_".rand(1000,9999).".".$ext;
	
	    $all_types = explode(",",strtolower($types));
	    if($types) {
	        if(in_array($ext,$all_types));
	        else {
//	            $result = "'".$filename."' is not a valid file."; //Show error if any.
//	            return array(null,$result);
				return null;
	        }
	    }
	
	    //Where the file must be uploaded to
	    if($folder) $folder .= '/';//Add a '/' at the end of the folder
	    $uploadfile = $folder . $file_name;
	
	    $result = null;
	    //Move the file from the stored location to the new location
	    if (!move_uploaded_file($tmpname, $uploadfile)) {
	        $result = "Cannot upload the file '".$filename."'"; //Show error if any.
	        if(!file_exists($folder)) {
	            $result .= " : Folder don't exist.";
	        } elseif(!is_writable($folder)) {
	            $result .= " : Folder not writable.";
	        } elseif(!is_writable($uploadfile)) {
	            $result .= " : File not writable.";
	        }
	        $file_name = null;
	        
	    } else {
	        if(!$filesize) { //Check if the file is made
	            @unlink($uploadfile);//Delete the Empty file
	            $file_name = null;
	            $result = "Empty file found - please use a valid file."; //Show the error message
	        } else {
	            chmod($uploadfile,0777);//Make it universally writable.
	        }
	    }
	
	    return $file_name;
	}
} 