<?php
class FacultiesController extends AppController {
	var $name = 'Faculties';
	
	public $uses = array('Faculty','Content','Department');
	
	public $components = array('Paginator','FileUpload');
	
	
	function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('view');
	}

	function index($status = null, $deptid = null) {
		$this->layout = 'inner';
		$this->Faculty->recursive = 0;
		if($status == null) $status = 0;
		if($deptid == null){
			$this->paginate = array('conditions' => array('Faculty.isactive' => $status),'limit'=>20,'order'=>array('Faculty.order'=>'ASC'));		
		}else{																				
			$this->paginate = array('conditions' => array('Faculty.department_id' => $deptid,'Faculty.isactive' => $status),'limit'=>20,'order'=>array('Faculty.order'=>'ASC'));	
		}
		$this->set('faculties', $this->Paginator->paginate($this->Faculty));
	}

	function view($id = null) {
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid Faculty Id.', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('faculty', $this->Faculty->read(null, $id));
	}
	
	function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Faculty' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Faculty->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }
	
	function admin_index() {
		$this->layout = 'default';
		$this->Faculty->recursive = 0;
		$this->paginate = array('order'=>'Faculty.created DESC');
		$this->set('faculties', $this->Paginator->paginate());
	}
   
	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['Faculty']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."photo";
					$target_path_for_database ="files"."/"."photo/";
					$filename = $this->request->data['Faculty']['attachfile']['name'];
					$tmpname  = $this->request->data['Faculty']['attachfile']['tmp_name'];
					$filesize = $this->request->data['Faculty']['attachfile']['size'];
					$filetype = $this->request->data['Faculty']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif');				
					if(strlen($filename1) > 0){
						$this->request->data['Faculty']['image'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			$this->Faculty->create();
			if ($this->Faculty->save($this->request->data)) {
				$this->Session->setFlash(__('The faculty infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The faculty infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
		$departments = array('0'=>'Select Department/Section')+ $this->Department->find('list');
		$this->set(compact('departments'));
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid infromation!', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Faculty']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				$filename = $this->request->data['Faculty']['attachfile']['name'];
				$tmpname  = $this->request->data['Faculty']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Faculty']['attachfile']['size'];
				$filetype = $this->request->data['Faculty']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif');					
				if(strlen($filename1) > 0){
					
					if(!empty($this->request->data['Faculty']['image'])){
						if(unlink($this->request->data['Faculty']['image'])){
							$this->request->data['Faculty']['image'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['Faculty']['image'] = $target_path_for_database.$filename1;						
					}
					
				}
				
			}
			if ($this->Faculty->save($this->request->data)) {
				$this->Session->setFlash(__('The faculty infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The faculty infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Faculty']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Faculty->read(null, $id);
		}
		$departments = array('0'=>'Select Department/Section')+ $this->Department->find('list');
		$this->set(compact('departments'));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Faculty infromation!', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Faculty->find('first',array('conditions'=>array('Faculty.id'=>$id),'fields'=>array('Faculty.image')));
		if(!empty($filename['Faculty']['image'])){
			if(unlink($filename['Faculty']['image'])){
				if ($this->Faculty->delete($id)) {
					$this->Session->setFlash(__('Faculty infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Faculty->delete($id)) {
					$this->Session->setFlash(__('The Faculty has been deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}
		}else{
			if ($this->Faculty->delete($id)) {
				$this->Session->setFlash(__('The Faculty has been deleted.', true));
				$this->redirect(array('action'=>'index'));
			}
		}
		
		
		
		$this->Session->setFlash(__('Faculty infromation was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>