<?php
App::uses('AppController', 'Controller');
/**
 * PhotoCategories Controller
 *
 * @property PhotoCategory $PhotoCategory
 * @property PaginatorComponent $Paginator
 */
class PhotoCategoriesController extends AppController {
	
	public function beforeFilter() {
		parent::beforeFilter();
		// For CakePHP 2.1 and up
		//$this->Auth->allow();
	}


/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator','FileUpload');

/**
 * index method
 *
 * @return void
 */
	public function admin_index() {
		
		$this->PhotoCategory->recursive = 0;
		$this->set('photocategories', $this->Paginator->paginate());
	}

/**
 * add method
 *
 * @return void
 */
	public function admin_add() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['PhotoCategory']['categoryfile']['name'] != null){	
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				
				$filename = $this->request->data['PhotoCategory']['categoryfile']['name'];
				$tmpname  = $this->request->data['PhotoCategory']['categoryfile']['tmp_name'];
				$filesize = $this->request->data['PhotoCategory']['categoryfile']['size'];
				$filetype = $this->request->data['PhotoCategory']['categoryfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp');
				
				if(strlen($newfilename) > 0){
					$this->request->data['PhotoCategory']['category_image'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->PhotoCategory->create();
			if ($this->PhotoCategory->save($this->request->data)) {
				$this->Session->setFlash(__('The category has been saved.'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The category could not be saved. Please, try again.'));
				return $this->redirect(array('action' => 'add'));
			}
		}
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
		
		$this->PhotoCategory->id = $id;
		if (!$this->PhotoCategory->exists()) {
			throw new NotFoundException(__('Invalid category'));
		}
		
		$filename = $this->PhotoCategory->find('first',array('conditions'=>array('PhotoCategory.id'=>$id),'fields'=>array('PhotoCategory.category_image')));
		if(!empty($filename['PhotoCategory']['category_image'])){
			if(unlink($filename['PhotoCategory']['category_image'])){
				if ($this->PhotoCategory->delete()) {
					$this->Session->setFlash(__('The category has been deleted.'));
				} else {
					$this->Session->setFlash(__('The category could not be deleted. Please, try again.'));
				}
				return $this->redirect(array('action' => 'index'));
			}else{
				if ($this->PhotoCategory->delete()) {
					$this->Session->setFlash(__('The category has been deleted.'));
				}
			}
		}else{
			if ($this->PhotoCategory->delete()) {
				$this->Session->setFlash(__('The category has been deleted.'));
			}
		}
					
	}
}
