<?php
App::uses('AppModel', 'Model');
/**
 * Content Model
 *
 */
class Content extends AppModel {

	/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'pagename' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				'message' => 'Please input a title.',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		
	);
	
	public function beforeSave($options = array()){
	
		$data = $this->data;
		if(empty($data[$this->alias]['id'])){
			
			$slug = $this->slugify($data['Content']['pagename']);
			$check_slug = $this->find('count',array('conditions'=>array('pagealias'=>$slug)));
			if($check_slug == 0){
				$data['Content']['pagealias'] = $str = strtolower($slug);
				
			}
			$this->data = $data;
			
		 }
		return true;
	}
	
}
